/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.console;

import com.ibm.hsc.common.util.PIHscUtil;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Properties;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMClient;

public class CreateHscConsole {
    public static int CreateHscConsoleTimeout = 600000;
    public static int CreateHscConsoleRetryInterval = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Throwable {
        CIMObjectPath cIMObjectPath = null;
        CIMClient cIMClient = null;
        String string = CreateHscConsole._getHostName();
        long l = System.currentTimeMillis();
        int n = 0;
        System.out.println("inside create hsc console");
        PIHscUtil.initHscUtil(3);
        while (n == 0) {
            try {
                cIMClient = PIHscUtil.openCIMClient(string);
                cIMObjectPath = new CIMObjectPath("IBMHSC_Console");
                CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false);
                CIMInstance cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Console"));
                cIMInstance.setProperty("Name", new CIMValue((Object)"DefaultName"));
                cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
                cIMClient.createInstance(cIMObjectPath, cIMInstance);
                System.out.println("connected to cimom " + (System.currentTimeMillis() - l));
                break;
            }
            catch (Throwable throwable) {
                System.out.println("catches exception: " + throwable);
                n = 1;
                long l2 = System.currentTimeMillis();
                if (l2 - l < (long)CreateHscConsoleTimeout) {
                    Thread.currentThread();
                    Thread.sleep(CreateHscConsoleRetryInterval);
                    n = 0;
                    System.out.println("Waiting for HMC to start " + (l2 - l));
                    continue;
                }
                throwable.printStackTrace();
            }
            finally {
                if (cIMClient == null) continue;
                cIMClient.close();
            }
        }
        System.exit(n);
    }

    private static String _getHostName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            string = "localhost";
        }
        return string;
    }

    static {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("/opt/hsc/data/hmc.properties"));
            String string = properties.getProperty("CreateHscConsoleTimeoutInSec");
            System.out.println("CreateHscConsoleTimeoutInSec is: " + string);
            if (string != null) {
                CreateHscConsoleTimeout = Integer.parseInt(string) * 1000;
            }
            string = properties.getProperty("CreateHscConsoleRetryIntervalInSec");
            System.out.println("CreateHscConsoleRetryIntervalInSec is: " + string);
            if (string != null) {
                CreateHscConsoleRetryInterval = Integer.parseInt(string) * 1000;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

